Imports ADODB


Public Class EmployeePeriod
    Inherits System.ComponentModel.Component

#Region " Component Designer generated code "

    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyClass.New()

        'Required for Windows.Forms Class Composition Designer support
        Container.Add(Me)
    End Sub
    Friend WithEvents OleDbSelectCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbInsertCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbUpdateCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbDeleteCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbDataAdapter1 As System.Data.OleDb.OleDbDataAdapter
                        
    Public Sub New()
        MyBase.New()

        'This call is required by the Component Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        SetupTableMap()
    End Sub

    'Required by the Component Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.OleDbSelectCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbInsertCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbUpdateCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbDeleteCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbDataAdapter1 = New System.Data.OleDb.OleDbDataAdapter()
        '
        'OleDbDataAdapter1
        '
        Me.OleDbDataAdapter1.DeleteCommand = Me.OleDbDeleteCommand1
        Me.OleDbDataAdapter1.InsertCommand = Me.OleDbInsertCommand1
        Me.OleDbDataAdapter1.SelectCommand = Me.OleDbSelectCommand1
        Me.OleDbDataAdapter1.UpdateCommand = Me.OleDbUpdateCommand1

    End Sub

#End Region

    Private Sub SetupTableMap()
        'Setup the table mapping for the OleDbDataAdapter
        Me.OleDbDataAdapter1.TableMappings.AddRange(New Data.Common.DataTableMapping() {New Data.Common.DataTableMapping("employee_period", "EmployeePeriod", New Data.Common.DataColumnMapping() {New Data.Common.DataColumnMapping("employee", "Employee"), New Data.Common.DataColumnMapping("period", "Period"), New Data.Common.DataColumnMapping("employee_period_state", "EmployeePeriodState"), New Data.Common.DataColumnMapping("audit_note", "AuditNote")})})
    End Sub

    Public Function BrowseByPeriod(ByVal Period As Date) As EmployeePeriodDS
        Dim Recordset As _Recordset
        Dim EmployeePeriodInfo As New EmployeePeriodDS()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseByPeriod(Period)

        OleDbDataAdapter1.Fill(EmployeePeriodInfo, Recordset, "employee_period")

        Return EmployeePeriodInfo

    End Function


    Public Function BrowseByEmployee(ByVal Employee As String) As EmployeePeriodDS
        Dim Recordset As _Recordset
        Dim EmployeePeriodInfo As New EmployeePeriodDS()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseByEmployee(Employee)

        OleDbDataAdapter1.Fill(EmployeePeriodInfo, Recordset, "employee_period")

        Return EmployeePeriodInfo

    End Function


    Public Function BrowseCalendarByRange(ByVal StartDate As Date, ByVal StopDate As Date) As DataSet
        Dim Recordset As _Recordset
        Dim CalendarInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseCalendarByRange(StartDate, StopDate)

        OleDbDataAdapter1.Fill(CalendarInfo, Recordset, "Calendar")

        Return CalendarInfo

    End Function


    Public Function BrowseCalendarByPeriod(ByVal Period As Date) As DataSet
        Dim Recordset As _Recordset
        Dim CalendarInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseCalendarByPeriod(Period)

        OleDbDataAdapter1.Fill(CalendarInfo, Recordset, "Calendar")

        Return CalendarInfo

    End Function


    Public Function BrowseEmployee(ByVal ActiveOnly As Boolean) As DataSet
        Dim Recordset As _Recordset
        Dim EmployeeInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseEmployee(ActiveOnly)

        OleDbDataAdapter1.Fill(EmployeeInfo, Recordset, "Employee")

        Return EmployeeInfo

    End Function


    Public Function BrowseProjects() As DataSet
        Dim Recordset As _Recordset
        Dim ProjectInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseProjects()

        OleDbDataAdapter1.Fill(ProjectInfo, Recordset, "proj")

        Return ProjectInfo

    End Function


    Public Function BrowseEmployeeTaskByEmployee(ByVal Employee As String) As DataSet
        Dim Recordset As _Recordset
        Dim EmployeeInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseEmployeeTaskByEmployee(Employee)

        OleDbDataAdapter1.Fill(EmployeeInfo, Recordset, "Employee")

        Return EmployeeInfo

    End Function


    Public Function BrowseExpenseCategory() As DataSet
        Dim Recordset As _Recordset
        Dim ExpenseInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseExpenseCategory()

        OleDbDataAdapter1.Fill(ExpenseInfo, Recordset, "expense_category")

        Return ExpenseInfo

    End Function


    Public Function BrowseExpenseType() As DataSet
        Dim Recordset As _Recordset
        Dim ExpenseInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseExpenseType()

        OleDbDataAdapter1.Fill(ExpenseInfo, Recordset, "expense_category")

        Return ExpenseInfo

    End Function


    Public Function BrowsePeriod() As DataSet
        Dim Recordset As _Recordset
        Dim PeriodInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowsePeriod()

        OleDbDataAdapter1.Fill(PeriodInfo, Recordset, "period")

        Return PeriodInfo

    End Function


    Public Function BrowseTimeType() As DataSet
        Dim Recordset As _Recordset
        Dim TimeTypeInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.BrowseTimeType()

        OleDbDataAdapter1.Fill(TimeTypeInfo, Recordset, "time_type")

        Return TimeTypeInfo

    End Function


    Public Function GetSecurityInfo() As DataSet
        Dim Recordset As _Recordset
        Dim SecurityInfo As New DataSet()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.GetSecurityInfo()

        OleDbDataAdapter1.Fill(SecurityInfo, Recordset, "security")

        Return SecurityInfo

    End Function


    Public Function Create() As EmployeePeriodDS
        Dim Recordset As _Recordset
        Dim EmployeePeriodInfo As New EmployeePeriodDS()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.Create()

        OleDbDataAdapter1.Fill(EmployeePeriodInfo, Recordset, "employee_period")

        Return EmployeePeriodInfo
    End Function


    Public Function Load(ByVal Employee As String, ByVal Period As Date) As EmployeePeriodDS
        Dim Recordset As _Recordset
        Dim EmployeePeriodInfo As New EmployeePeriodDS()
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()

        Recordset = EmployeePeriod.Load(Employee, Period)

        OleDbDataAdapter1.Fill(EmployeePeriodInfo, Recordset, "employee_period")

        Return EmployeePeriodInfo

    End Function


    Public Function Save(ByVal EmployeePeriodInfo As EmployeePeriodDS) As EmployeePeriodDS
        Dim Recordset As _Recordset
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()
        Dim RowsAffected As Integer


        ' Create an empty EmployeePeriod Recordset
        Recordset = EmployeePeriod.Create()

        ' Populate the recordset with data from the dataset
        CopyToRecordset(Recordset, EmployeePeriodInfo)

        ' Save the employee period
        RowsAffected = EmployeePeriod.Save(Recordset)

        If RowsAffected = 0 Then
            ' Throw an execption
        End If

        Return EmployeePeriodInfo

    End Function


    Public Function Add(ByVal EmployeePeriodInfo As EmployeePeriodDS) As EmployeePeriodDS
        Dim Recordset As _Recordset
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()
        Dim RowsAffected As Integer

        ' Create an empty EmployeePeriod Recordset
        Recordset = EmployeePeriod.Create()

        ' Populate the recordset with data from the dataset
        CopyToRecordset(Recordset, EmployeePeriodInfo)

        ' Save the employee period
        RowsAffected = EmployeePeriod.Add(Recordset)

        If RowsAffected = 0 Then
            ' Throw an execption
        End If

        Return EmployeePeriodInfo

    End Function


    Public Function Delete(ByVal Employee As String, ByVal Period As Date) As Integer
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()
        Dim RowsAffected As Integer

        RowsAffected = EmployeePeriod.Delete(Employee, Period)

        Return RowsAffected

    End Function


    Public Function EmployeeComplete(ByVal Employee As String, ByVal Period As Date) As Boolean
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()
        Dim IsComplete As Boolean

        IsComplete = EmployeePeriod.EmployeeComplete(Employee, Period)

        Return IsComplete

    End Function


    Public Function AuditorComplete(ByVal Employee As String, ByVal Period As Date) As Boolean
        Dim EmployeePeriod As New TnEADO.EmployeePeriod()
        Dim IsComplete As Boolean

        IsComplete = EmployeePeriod.AuditorComplete(Employee, Period)

        Return IsComplete

    End Function

    Private Sub CopyToRecordset(ByRef Recordset As ADODB._Recordset, ByVal EmployeePeriodInfo As EmployeePeriodDS)
        With EmployeePeriodInfo
            If .EmployeePeriod.Rows.Count > 0 Then
                Recordset.Fields.Item("employee").Value = .EmployeePeriod(0).Employee
                Recordset.Fields.Item("period").Value = .EmployeePeriod(0).Period
                Recordset.Fields.Item("employee_period_state").Value = .EmployeePeriod(0).EmployeePeriodState
                Recordset.Fields.Item("audit_note").Value = .EmployeePeriod(0).AuditNote
            End If
        End With
    End Sub

End Class
